#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_TestResult : BaseTest
	{
		private BOL.TestResult _testResult;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
			//
			this._testResult = new TestResult( UnitTestUtil.RunSQLGetDataRow( "SELECT TOP 1 * FROM TestResult" ) );
		}

		[Test]
		public void Ctor_Pass()
		{
			BOL.TestResult tr = new TestResult();
			//
			Assert.IsNotNull( tr );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void Ctor_String_Pass()
		{
			DataRow dr = UnitTestUtil.RunSQLGetDataRow( "SELECT TOP 1 TestResultId FROM TestResult" );
			//
			BOL.TestResult tr = new TestResult( dr[TABLES.TestResult.TestResultId].ToString() );
			//
			Assert.IsNotNull( tr );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_String_Fail()
		{
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			DataRow dr = UnitTestUtil.RunSQLGetDataRow( "SELECT TOP 1 * FROM TestResult" );
			//
			BOL.TestResult tr = new TestResult( dr );
			//
			Assert.IsNotNull( tr );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{
		}

		[Test]
		public void TestResultId_Pass()
		{
			string testId = "0";
			//
			this._testResult.TestResultId = testId;
			//
			Assert.AreEqual( this._testResult.TestResultId, testId );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestResultId_Fail()
		{
		}

		[Test]
		public void TestResultText_Pass()
		{
			string testText = "Some Test";
			//
			this._testResult.TestResultText = testText;
			//
			Assert.AreEqual( this._testResult.TestResultText, testText );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestResultText_Fail()
		{
		}
		[Test]
		public void GetTestResults_Pass()
		{
			System.Guid pOrderGuid = System.Guid.NewGuid();

			StringBuilder query = new StringBuilder( "SELECT TOP 1 PatientOrderGUID FROM dbo.PatientTest PT " );
			query.Append( "JOIN dbo.SpecimenTestThreshold STT ON STT.LabTestID = PT.LabTestID " );
			query.Append( "WHERE PT.DivisionCode = '" );
			query.Append( UnitTestConfig.TestDivisionCode );
			query.Append( "'" );

			DataTable dtTest = UnitTestUtil.RunSQLGetDataTable( query.ToString() );
			
			if (dtTest.Rows.Count == 0)
			{
				System.Collections.ArrayList dtList = new ArrayList();
				System.Collections.ArrayList sprocList = new ArrayList();

				//Create a PatientTest
				DataRow dr = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM PatientTreatment");
				System.Guid patientGuid = (System.Guid)dr[TABLES.Patient.PatientGuid];
				System.Guid pTreatmentGuid = (System.Guid)dr[TABLES.PatientTreatment.PatientTreatmentGuid];
				string labTestId = new Random().Next(999,999999).ToString();

				//Create a PatientOrder
				dtList.Add(SprocHelper.GetInsertPatientOrderSprocTable(pOrderGuid, pTreatmentGuid));
				sprocList.Add(Common.VbecsStoredProcs.InsertPatientOrder.StoredProcName);

				//Create a PatientTest
				dtList.Add(SprocHelper.GetHL7UpdatePatientTest(patientGuid, pOrderGuid, labTestId, 8));
				sprocList.Add(Common.VbecsStoredProcs.HL7UpdatePatientTest.StoredProcName);

				//Create a SpecimenTestThreshold
				dtList.Add(SprocHelper.GetInsertSpecimenTestThresholdSprocTable(System.Guid.NewGuid(), labTestId));
				sprocList.Add(Common.VbecsStoredProcs.InsertSpecimenTestThreshold.StoredProcName);

				//Common.Utility.DumpTransactionalInputs(sprocList, dtList, "testxxx.txt");

				int rc = new Common.StoredProcedure().TransactionalGetValue(sprocList,dtList);
				Assert.AreEqual(0, rc, "Creating Test Data");
			}
			else
			{
				pOrderGuid = (System.Guid)dtTest.Rows[0][TABLES.PatientOrder.PatientOrderGuid];
			}

			DataTable results = BOL.TestResult.GetTestResults(pOrderGuid);
			
			Assert.IsTrue( results.Rows.Count > 0 );
		}

		[Test]
		public void GetTestResults_Fail()
		{
			DataTable results = BOL.TestResult.GetTestResults( Guid.NewGuid() );
			//
			Assert.IsTrue( results.Rows.Count == 0 );
		}
	}
}
#endif
